/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.preloginmonitor;

import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.HWMessagesExistProperty;
import com.ibm.hwmca.fw.managed.OSMessagesExistProperty;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.UnacceptableManagedObjects;
import com.ibm.hwmca.fw.servlet.preloginmonitor.PreLoginMonitor;
import com.ibm.hwmca.fw.settings.user.DefaultUserSettings;
import com.ibm.hwmca.fw.settings.user.ObjectBackgroundSettings;
import com.ibm.hwmca.fw.tasklet.Tasklet;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.TaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.Trace;
import java.util.HashMap;

public class PreLoginMonitorTasklet
extends Tasklet {
    private static final String TRACE_MASKT = "XPLMONST";
    private static final String TRACE_MASKD = "XPLMONSD";
    private UnacceptableManagedObjects m_UMO;
    private HWMessagesExistProperty m_hwMessagesExistProperty;
    private OSMessagesExistProperty m_osMessagesExistProperty;
    private DefaultUserSettings m_dusSettings;
    private ObjectBackgroundSettings m_obsSettings;
    String[] m_saStatus;

    public PreLoginMonitorTasklet() {
        Trace.trace(TRACE_MASKT, "<> PreLoginMonitorlet.PreLoginMonitorlet()");
    }

    public void init(Object initData) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> PreLoginMonitorTasklet.init()");
        this.m_UMO = UnacceptableManagedObjects.getUnacceptableManagedObjects();
        this.m_hwMessagesExistProperty = HWMessagesExistProperty.getHWMessagesExistProperty();
        this.m_osMessagesExistProperty = OSMessagesExistProperty.getOSMessagesExistProperty();
        this.m_dusSettings = DefaultUserSettings.getDefaultUserSettings();
        this.m_saStatus = new String[3];
    }

    public void service(TaskletRequest request, TaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> PreLoginMonitorTasklet.service()");
        if (!request.isInitialRequest()) {
            String source = (String)request.getData("aRequestKey");
            this.m_obsSettings = (ObjectBackgroundSettings)this.m_dusSettings.getUserSettings("com.ibm.hwmca.fw.settings.user.ObjectBackgroundSettings");
            if (source.equals("getAllStati")) {
                this.serviceStatusRequest(request, response);
            } else if (source.equals("getIconsAndCaptions")) {
                this.serviceIconsCaptionsRequest(request, response);
            }
        }
        response.noAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceStatusRequest(TaskletRequest request, TaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> PreLoginMonitorTasklet.serviceStatusRequest()");
        String[] stringArray = this.m_saStatus;
        synchronized (this.m_saStatus) {
            this.m_saStatus[0] = this.getManagedObjectsStateGraphic();
            this.m_saStatus[1] = this.getHWMessagesStateBackgroundImage();
            this.m_saStatus[2] = this.getOSMessagesStateBackgroundImage();
            response.setData("getAllStati", this.m_saStatus);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    protected void serviceIconsCaptionsRequest(TaskletRequest request, TaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> PreLoginMonitorTasklet.serviceIconsCaptionsRequest()");
        HashMap<String, String> hmIconsCaptions = new HashMap<String, String>(6);
        UIInfo aUIInfo = this.getUIInfo("base.task.hwmsg");
        hmIconsCaptions.put("hwmsgs.icon", aUIInfo.getImageName());
        hmIconsCaptions.put("hwmsgs.name", aUIInfo.getName());
        hmIconsCaptions.put("hwmsgs.caption", aUIInfo.getCaption());
        aUIInfo = this.getUIInfo("base.task.osmsg");
        hmIconsCaptions.put("osmsgs.icon", aUIInfo.getImageName());
        hmIconsCaptions.put("osmsgs.name", aUIInfo.getName());
        hmIconsCaptions.put("osmsgs.caption", aUIInfo.getCaption());
        response.setData("getIconsAndCaptions", hmIconsCaptions);
    }

    private String getManagedObjectsStateGraphic() {
        Trace.trace(TRACE_MASKT, "-> PreLoginMonitorTasklet.getManagedObjectsStateGraphic()");
        boolean bUnacceptManagedObjects = this.m_UMO.isUnacceptable();
        return this.m_obsSettings.getBackgroundImageName(!bUnacceptManagedObjects);
    }

    private String getHWMessagesStateBackgroundImage() {
        Trace.trace(TRACE_MASKT, "-> PreLoginMonitorTasklet.getHWMessagesStateBackgroundImage()");
        if (this.m_hwMessagesExistProperty.isHWMessages()) {
            ObjectId hwMsgsOID = this.getTaskObjectID("base.task.hwmsg");
            return this.m_obsSettings.getAnimatedAttentionImageName(hwMsgsOID);
        }
        return "/res/com/ibm/hwmca/fw/images/transparent.gif";
    }

    private String getOSMessagesStateBackgroundImage() {
        Trace.trace(TRACE_MASKT, "-> PreLoginMonitorTasklet.getOSMessagesStateBackgroundImage()");
        if (this.m_osMessagesExistProperty.isOSMessages()) {
            ObjectId osMsgsOID = this.getTaskObjectID("base.task.osmsg");
            return this.m_obsSettings.getAnimatedAttentionImageName(osMsgsOID);
        }
        return "/res/com/ibm/hwmca/fw/images/transparent.gif";
    }

    private UIInfo getUIInfo(String taskID) {
        Trace.trace(TRACE_MASKT, "-> PreLoginMonitorTasklet.getHWMessagesUIInfo()");
        ObjectId oid = this.getTaskObjectID(taskID);
        return this.m_obsSettings.getAttentionUIInfo(oid);
    }

    private ObjectId getTaskObjectID(String taskID) {
        Trace.trace(TRACE_MASKT, "-> PreLoginMonitorTasklet.getTaskObjectID()");
        ObjectId[] aOIDAttns = this.m_obsSettings.getAttentionTaskObjectIds();
        ObjectId oid = null;
        for (int i = 0; i < aOIDAttns.length; ++i) {
            oid = aOIDAttns[i];
            if (!taskID.equals(oid.getKeyProperty("Name"))) continue;
            return oid;
        }
        return oid;
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> PreLoginMonitorTasklet.logException(" + throwable + ")");
        new FrameworkLog(PreLoginMonitor.LOGINFO, 2048, throwable).log();
    }
}

